/*
 * Decompiled with CFR 0.152.
 */
package germ.model.workspace;

import germ.configuration.ConfigurationManager;
import germ.i18n.Messages;
import germ.model.workspace.Project;
import germ.util.Cursors;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.tree.TreeNode;

public class Workspace
implements TreeNode {
    private ArrayList<Project> projects = new ArrayList();

    public String toString() {
        return Messages.getString("Workspace.0");
    }

    public void addProject(Project diagram) {
        this.projects.add(diagram);
    }

    public void removeProject(Project p) {
        this.projects.remove(p);
    }

    public Project getProject(int index) {
        return this.projects.get(index);
    }

    public int getProjectIndex(Project project) {
        return this.projects.indexOf(project);
    }

    public int getProjectsCount() {
        return this.projects.size();
    }

    public boolean isLeaf() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return this.getProjectsCount();
    }

    public TreeNode getParent() {
        return null;
    }

    public int getIndex(TreeNode node) {
        return 0;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Enumeration children() {
        return null;
    }

    public static String workspaceChooser(Component parent) {
        JFileChooser workspaceChooser;
        String currentWorkspace = ConfigurationManager.getInstance().getString("workspace");
        if (Workspace.isValidWorkspace(currentWorkspace)) {
            File w = new File(currentWorkspace);
            workspaceChooser = new JFileChooser(w);
        } else {
            workspaceChooser = new JFileChooser(new File(System.getProperty("user.home")));
        }
        workspaceChooser.setDialogTitle(Messages.getString("Workspace.3"));
        workspaceChooser.setCursor(Cursors.getCursor("default"));
        workspaceChooser.setFileSelectionMode(1);
        if (workspaceChooser.showOpenDialog(parent) == 0) {
            String workspace = workspaceChooser.getSelectedFile().getAbsolutePath();
            return workspace;
        }
        return null;
    }

    public static boolean isValidWorkspace(String workspace) {
        if (workspace == null) {
            return false;
        }
        File w = new File(workspace);
        return w.exists() && w.isDirectory();
    }
}

