/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.actions.OpenSubDiagramAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.PropertyWindow;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Requirement;
import germ.state.State;
import germ.state.StateMachine;
import germ.util.Cursors;
import germ.view.GERMView;
import germ.view.Handle;
import germ.view.NodePainter;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JPopupMenu;

public class DefaultState
extends State {
    private Node mouseOverNode = null;
    int mouseButton = 0;

    public void mouseReleased(MouseEvent e) {
        Node node;
        GERMModel m = Application.getInstance().getModel();
        Point lastPosition = (Point)Application.getInstance().getView().lastPosition;
        int nodeId = m.getNodeAtPosition(lastPosition);
        if (e.getButton() == 1 && nodeId != -1 && !e.isControlDown()) {
            node = m.getNodeAt(nodeId);
            m.deselectAllNodes();
            m.selectNode(node);
        }
        if (e.getButton() == 3) {
            node = null;
            JPopupMenu popup = Application.getInstance().getMainWindow().getPopupMenu();
            if (nodeId != -1) {
                node = m.getNodeAt(nodeId);
                if (!m.isNodeIsSelected(node).booleanValue()) {
                    m.deselectAllNodes();
                    m.selectNode(node);
                }
                m.nodeToFront(nodeId);
            } else {
                m.deselectAllNodes();
            }
            if (m.selectedNodesCount() <= 0) {
                popup.getComponent(5).setEnabled(false);
                popup.getComponent(6).setEnabled(false);
                popup.getComponent(7).setEnabled(false);
                popup.getComponent(8).setEnabled(false);
                popup.getComponent(9).setEnabled(false);
                popup.getComponent(10).setEnabled(false);
            } else {
                popup.getComponent(6).setEnabled(true);
                if (m.selectedNodesCount() != 1) {
                    popup.getComponent(5).setEnabled(false);
                    popup.getComponent(9).setEnabled(false);
                    popup.getComponent(10).setEnabled(true);
                } else {
                    if (m.getSelectedNodes().get(0) instanceof Requirement) {
                        Requirement r = (Requirement)m.getSelectedNodes().get(0);
                        if (r.isComplex()) {
                            OpenSubDiagramAction osd = Application.getInstance().getActionManager().getOpenSubDiagramAction();
                            osd.setRequirement((Requirement)node);
                            popup.getComponent(5).setEnabled(true);
                        } else {
                            popup.getComponent(5).setEnabled(false);
                        }
                    } else {
                        popup.getComponent(5).setEnabled(false);
                    }
                    popup.getComponent(6).setEnabled(true);
                    popup.getComponent(7).setEnabled(true);
                    popup.getComponent(9).setEnabled(true);
                    popup.getComponent(10).setEnabled(false);
                }
            }
            popup.show(Application.getInstance().getView(), e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
        Application.getInstance().getMainWindow().stopScroll();
        this.mouseButton = e.getButton();
        GERMModel m = Application.getInstance().getModel();
        StateMachine sm = Application.getInstance().getStateMachine();
        Point lastPosition = (Point)Application.getInstance().getView().lastPosition;
        GERMView v = Application.getInstance().getView();
        int nodeId = m.getNodeAtPosition(lastPosition);
        int link = -1;
        if (e.getButton() == 1) {
            if (v.getHandleMoving() != null && v.getNodeChangingShape() != null) {
                State.resizeState.initializeResize(lastPosition);
                sm.setState(State.resizeState);
            } else {
                if (nodeId != -1) {
                    Node hitNode = m.getNodeAt(nodeId);
                    if (((NodePainter)hitNode.getPainter()).isCenterHit(lastPosition) && m.getSelectedLink() != null) {
                        if (hitNode == m.getSelectedLink().getSource()) {
                            State.reconnectState.initializeMove(true, hitNode);
                        } else {
                            State.reconnectState.initializeMove(false, hitNode);
                        }
                        sm.setState(State.reconnectState);
                    } else {
                        if (!e.isControlDown()) {
                            if (!m.isNodeIsSelected(hitNode).booleanValue()) {
                                m.deselectAllNodes();
                                m.selectNode(hitNode);
                            }
                        } else {
                            m.toggleNodeSelect(hitNode, true);
                        }
                        m.nodeToFront(nodeId);
                        m.setSelectedLink(null);
                    }
                } else {
                    link = m.getLinkAtPosition(lastPosition);
                    if (link != -1) {
                        m.deselectAllNodes();
                        m.setSelectedLink(m.getLinkAt(link));
                        m.setSelectedBreakpoint(lastPosition);
                    }
                }
                if (nodeId == -1 && link == -1) {
                    m.setSelectedLink(null);
                    if (!e.isControlDown()) {
                        m.deselectAllNodes();
                    }
                    sm.setState(State.lasoState);
                    m.setLasoBegin(lastPosition);
                }
            }
        } else if (e.getButton() == 2) {
            sm.setState(State.handMoveState);
        }
    }

    public void mouseDragged(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        StateMachine sm = Application.getInstance().getStateMachine();
        Point lastPosition = (Point)v.lastPosition;
        int node = m.getNodeAtPosition(lastPosition);
        if (this.mouseButton == 1) {
            if (node != -1) {
                sm.setState(State.moveState);
                State.moveState.initializeMove(m.getNodeAt(node));
            } else if (m.getSelectedBreakpoint() != null) {
                sm.setState(State.moveBreakpointState);
                State.moveBreakpointState.initializeMove();
            }
        }
    }

    public void mouseDoubleClicked(MouseEvent e) {
        Point lastPosition = (Point)Application.getInstance().getView().lastPosition;
        GERMModel m = Application.getInstance().getModel();
        int node = m.getNodeAtPosition(lastPosition);
        if (node != -1) {
            Node selectedNode = m.getNodeAt(node);
            PropertyWindow property = selectedNode.getPropertyWindow();
            property.setVisible(true);
            selectedNode.setProperties(property.isDialogResult());
            m.updatePerformed();
        } else {
            int link = m.getLinkAtPosition(lastPosition);
            if (link != -1) {
                m.setSelectedLink(m.getLinkAt(link));
                m.setSelectedBreakpoint(lastPosition);
                if (m.getSelectedBreakpoint() != null) {
                    m.getSelectedLink().deleteBreakpoint(m.getSelectedBreakpoint());
                } else {
                    m.getSelectedLink().insertNewBreakpoint(lastPosition);
                }
                m.setSelectedBreakpoint(null);
                m.updatePerformed();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        GERMModel m = Application.getInstance().getModel();
        ConfigurationManager cm = ConfigurationManager.getInstance();
        int offsetX = 0;
        int offsetY = 0;
        switch (e.getKeyCode()) {
            case 38: {
                offsetX = 0;
                offsetY = cm.getInt("arrowMoveStep");
                break;
            }
            case 40: {
                offsetX = 0;
                offsetY = -cm.getInt("arrowMoveStep");
                break;
            }
            case 37: {
                offsetX = cm.getInt("arrowMoveStep");
                offsetY = 0;
                break;
            }
            case 39: {
                offsetX = -cm.getInt("arrowMoveStep");
                offsetY = 0;
            }
        }
        MoveCommand moveCommand = null;
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
            moveCommand = new MoveCommand();
            m.updateSelectedNodesPosition(offsetX, offsetY);
            moveCommand.moveEnded();
            Application.getInstance().getCommandManager().doCommand(moveCommand);
        }
    }

    public void mouseMove(MouseEvent e) {
        GERMView v = Application.getInstance().getView();
        GERMModel m = Application.getInstance().getModel();
        Point pos = new Point();
        try {
            v.getTransform().inverseTransform(e.getPoint(), pos);
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        Handle h = v.getHandleForPoint(pos);
        if (h != null) {
            v.setMouseCursor(pos);
        } else {
            v.setCursor(Cursors.getCurrentCursor());
        }
        int nodeId = m.getNodeAtPosition(pos);
        if (nodeId != -1) {
            Node n = m.getNodeAt(nodeId);
            if (this.mouseOverNode == null) {
                this.mouseOverNode = n;
                m.setMouseOverNode(n);
                m.updatePerformed();
            }
            if (n != this.mouseOverNode) {
                m.setMouseOverNode(n);
                m.updatePerformed();
            }
        } else {
            this.mouseOverNode = null;
            m.setMouseOverNode(null);
            m.updatePerformed();
        }
    }

    public void enter() {
        Application.getInstance().getView().setCursor(Cursors.getCursor("default"));
    }
}

