/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.state.State;
import germ.util.Cursors;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class HandMoveState
extends State {
    Point previousPosition = null;

    public void mouseDragged(MouseEvent e) {
        GERMView v = Application.getInstance().getView();
        if (this.previousPosition == null) {
            this.previousPosition = e.getPoint();
        } else {
            AffineTransform transform = v.getTransform();
            Point newPosition = e.getPoint();
            double offsetX = (newPosition.getX() - this.previousPosition.getX()) / transform.getScaleX();
            double offsetY = (newPosition.getY() - this.previousPosition.getY()) / transform.getScaleY();
            this.previousPosition = newPosition;
            v.moveWorkspace(offsetX, offsetY);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.previousPosition = null;
        Application.getInstance().getStateMachine().setState(State.defaultState);
    }

    public void enter() {
        Application.getInstance().getView().setCursor(Cursors.getCursor("hand"));
    }
}

