/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Link;
import germ.model.Node;
import germ.model.links.Author;
import germ.model.links.Dependency;
import germ.model.links.Interest;
import germ.model.links.Refine;
import germ.model.links.Support;
import germ.model.nodes.Argument;
import germ.model.nodes.Assumption;
import germ.model.nodes.Decision;
import germ.model.nodes.Position;
import germ.model.nodes.Requirement;
import germ.model.nodes.Stakeholder;
import germ.model.nodes.Topic;
import germ.state.State;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class InsertLinkBreakpointsState
extends State {
    boolean linkFinished = false;
    GERMModel m = null;

    public void mousePressed(MouseEvent e) {
        this.m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        if (e.getButton() == 1) {
            int node = this.m.getNodeAtPosition(v.lastPosition);
            if (node == -1) {
                this.m.getSelectedLink().addBreakPoint((Point)v.lastPosition);
                this.m.updatePerformed();
            } else if (this.m.getSelectedLink().getSource() != this.m.getNodeAt(node) && this.correctDestination(this.m.getSelectedLink(), this.m.getNodeAt(node))) {
                this.linkFinished = true;
                this.m.getSelectedLink().deleteBreakpointTail();
                this.m.getSelectedLink().setDestination(this.m.getNodeAt(node));
                this.m.updatePerformed();
                this.m.setSelectedLink(null);
                Application.getInstance().getStateMachine().setState(State.defaultState);
            } else {
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("InsertLinkBreakpointsState.1"), Messages.getString("InsertLinkBreakpointsState.2"), 1);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            Application.getInstance().getStateMachine().setState(State.insertLinkState);
        }
    }

    public void mouseMove(MouseEvent e) {
        GERMView v = Application.getInstance().getView();
        GERMModel m = Application.getInstance().getModel();
        int moveStep = 10;
        int moveX = 0;
        int moveY = 0;
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        if (m.getSelectedLink() != null) {
            m.getSelectedLink().deleteBreakpointTail();
            m.getSelectedLink().addBreakPoint((Point)v.lastPosition);
            if (e.isShiftDown()) {
                m.setSelectedBreakpoint((Point)v.lastPosition);
                m.updateSelectedBreakPointPosition90();
            }
        }
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance && e.getX() >= 0) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
        m.updatePerformed();
    }

    public void exit() {
        Application.getInstance().getCommandManager().refreshUndoRedoButtons(Application.getInstance());
        if (!this.linkFinished && this.m.getSelectedLink() != null) {
            this.m.removeLink(this.m.getSelectedLink());
            this.m.setSelectedLink(null);
            this.m.getCommandManager().removeLastCommand();
        }
        this.m = null;
    }

    private boolean correctDestination(Link link, Node node) {
        if (link instanceof Author && !(node instanceof Stakeholder)) {
            return true;
        }
        if (link instanceof Interest && node instanceof Requirement) {
            return true;
        }
        if (link instanceof Support && node instanceof Argument) {
            return true;
        }
        if (link instanceof Refine && node instanceof Requirement) {
            return true;
        }
        if (link instanceof Dependency) {
            if (link.getSource() instanceof Assumption && node instanceof Argument) {
                return true;
            }
            if (link.getSource() instanceof Argument && node instanceof Position) {
                return true;
            }
            if (link.getSource() instanceof Position && node instanceof Topic) {
                return true;
            }
            if (link.getSource() instanceof Topic && node instanceof Decision) {
                return true;
            }
            if (link.getSource() instanceof Decision && node instanceof Decision) {
                return true;
            }
        }
        return false;
    }

    void setLinkFinished(boolean f) {
        this.linkFinished = f;
    }
}

