/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.model.GERMModel;
import germ.state.State;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class LasoState
extends State {
    public void mouseDragged(MouseEvent e) {
        GERMView v = Application.getInstance().getView();
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        int moveStep = 6;
        int moveX = 0;
        int moveY = 0;
        Application.getInstance().getModel().setLasoEnd((Point)v.lastPosition);
        v.lasoEnabled = true;
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
    }

    public void mouseReleased(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        if (v.lasoEnabled) {
            m.selectNode(v.getLasoRectangle());
        }
        v.lasoEnabled = false;
        Application.getInstance().getStateMachine().setState(State.defaultState);
    }
}

