/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.command.MoveBreakpointCommand;
import germ.model.GERMModel;
import germ.state.State;
import germ.view.GERMView;
import java.awt.event.MouseEvent;

public class MoveBreakpointState
extends State {
    MoveBreakpointCommand moveBreakpointCommand;

    public void mouseDragged(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        int moveStep = 6;
        int moveX = 0;
        int moveY = 0;
        if (e.isShiftDown()) {
            m.updateSelectedBreakPointPosition90();
        } else {
            m.updateSelectedBreakPointPosition();
        }
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
    }

    public void mouseReleased(MouseEvent e) {
        Application app = Application.getInstance();
        app.getStateMachine().setState(State.defaultState);
        app.getModel().setSelectedBreakpoint(null);
        this.moveBreakpointCommand.moveEnded();
        app.getCommandManager().doCommand(this.moveBreakpointCommand);
    }

    public void initializeMove() {
        this.moveBreakpointCommand = new MoveBreakpointCommand();
    }
}

