/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.command.MoveCommand;
import germ.model.GERMModel;
import germ.model.Node;
import germ.state.State;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class MoveState
extends State {
    private Point lastPosition;
    MoveCommand moveCommand;
    private Node hitNode;

    public void mouseDragged(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        Point mousePosition = (Point)v.lastPosition;
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        int moveStep = 6;
        int moveX = 0;
        int moveY = 0;
        int xOffset = this.lastPosition.x - mousePosition.x;
        int yOffset = this.lastPosition.y - mousePosition.y;
        if (m.getSelectedNodes().size() > 0) {
            if (e.isShiftDown()) {
                m.updateSelectedNodesPosition90(this.hitNode, xOffset, yOffset);
            } else {
                m.updateSelectedNodesPosition(xOffset, yOffset);
            }
        }
        this.lastPosition = mousePosition;
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
    }

    public void mouseReleased(MouseEvent e) {
        Application app = Application.getInstance();
        app.getStateMachine().setState(State.defaultState);
        this.moveCommand.moveEnded();
        app.getCommandManager().doCommand(this.moveCommand);
    }

    public void exit() {
        Application.getInstance().getModel().getGhostNodes().clear();
        Application.getInstance().getModel().updatePerformed();
    }

    public void initializeMove(Node hitNode) {
        GERMModel m = Application.getInstance().getModel();
        this.lastPosition = (Point)Application.getInstance().getView().lastPosition;
        this.hitNode = hitNode;
        for (Node current : m.getSelectedNodes()) {
            m.addGhostNode(current);
        }
        this.moveCommand = new MoveCommand();
    }
}

