/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Link;
import germ.model.Node;
import germ.model.links.Author;
import germ.model.links.Dependency;
import germ.model.links.Interest;
import germ.model.links.Refine;
import germ.model.links.Support;
import germ.model.nodes.Argument;
import germ.model.nodes.Assumption;
import germ.model.nodes.Decision;
import germ.model.nodes.Position;
import germ.model.nodes.Requirement;
import germ.model.nodes.Stakeholder;
import germ.model.nodes.Topic;
import germ.state.State;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class ReconnectState
extends State {
    private boolean endPoint;
    private Node beginingNode;

    public void mouseDragged(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        int moveStep = 6;
        int moveX = 0;
        int moveY = 0;
        if (this.endPoint) {
            m.getSelectedLink().deleteBreakpointHead();
            m.getSelectedLink().addBreakPointBegining((Point)v.lastPosition);
        } else {
            m.getSelectedLink().deleteBreakpointTail();
            m.getSelectedLink().addBreakPoint((Point)v.lastPosition);
        }
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
    }

    public void mouseReleased(MouseEvent e) {
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        int node = m.getNodeAtPosition((Point)v.lastPosition);
        if (node != -1) {
            Node hitNode = m.getNodeAt(node);
            this.beginingNode.removeLink(m.getSelectedLink());
            if (this.endPoint) {
                m.getSelectedLink().deleteBreakpointHead();
                if (m.getSelectedLink().getDestination() == hitNode) {
                    m.getSelectedLink().setSource(this.beginingNode);
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ReconnectState.0"), Messages.getString("ReconnectState.1"), 2);
                } else {
                    Link link = m.getSelectedLink();
                    if (this.isValidSource(link, hitNode)) {
                        link.setSource(hitNode);
                    } else {
                        m.getSelectedLink().setSource(this.beginingNode);
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ReconnectState.5"), Messages.getString("ReconnectState.1"), 2);
                    }
                }
            } else {
                m.getSelectedLink().deleteBreakpointTail();
                if (m.getSelectedLink().getSource() == hitNode) {
                    m.getSelectedLink().setDestination(this.beginingNode);
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ReconnectState.2"), Messages.getString("ReconnectState.1"), 2);
                } else {
                    Link link = m.getSelectedLink();
                    if (this.isValidDestination(link, hitNode)) {
                        link.setDestination(hitNode);
                    } else {
                        m.getSelectedLink().setDestination(this.beginingNode);
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ReconnectState.3"), Messages.getString("ReconnectState.4"), 2);
                    }
                }
            }
        } else if (this.endPoint) {
            m.getSelectedLink().deleteBreakpointHead();
            m.getSelectedLink().setSource(this.beginingNode);
        } else {
            m.getSelectedLink().deleteBreakpointTail();
            m.getSelectedLink().setDestination(this.beginingNode);
        }
        m.updatePerformed();
        Application.getInstance().getStateMachine().setState(State.defaultState);
    }

    private boolean isValidDestination(Link link, Node node) {
        if (link instanceof Author && !(node instanceof Stakeholder)) {
            return true;
        }
        if (link instanceof Refine && node instanceof Requirement) {
            return true;
        }
        if (link instanceof Support && node instanceof Argument) {
            return true;
        }
        if (link instanceof Interest && node instanceof Requirement) {
            return true;
        }
        if (link instanceof Dependency) {
            if (link.getSource() instanceof Assumption && node instanceof Argument) {
                return true;
            }
            if (link.getSource() instanceof Argument && node instanceof Position) {
                return true;
            }
            if (link.getSource() instanceof Position && node instanceof Topic) {
                return true;
            }
            if (link.getSource() instanceof Topic && node instanceof Decision) {
                return true;
            }
            if (link.getSource() instanceof Decision && node instanceof Decision) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidSource(Link link, Node node) {
        if (link instanceof Author && node instanceof Stakeholder) {
            return true;
        }
        if (link instanceof Refine && node instanceof Requirement) {
            return true;
        }
        if (link instanceof Support && node instanceof Stakeholder) {
            return true;
        }
        if (link instanceof Interest && node instanceof Stakeholder) {
            return true;
        }
        if (link instanceof Dependency) {
            if (link.getDestination() instanceof Argument && node instanceof Assumption) {
                return true;
            }
            if (link.getDestination() instanceof Position && node instanceof Argument) {
                return true;
            }
            if (link.getDestination() instanceof Topic && node instanceof Position) {
                return true;
            }
            if (link.getDestination() instanceof Decision && (node instanceof Topic || node instanceof Decision)) {
                return true;
            }
        }
        return false;
    }

    public void initializeMove(boolean endPoint, Node node) {
        this.endPoint = endPoint;
        this.beginingNode = node;
        GERMModel m = Application.getInstance().getModel();
        GERMView v = Application.getInstance().getView();
        if (endPoint) {
            m.getSelectedLink().setSource(null);
            m.getSelectedLink().addBreakPointBegining((Point)v.lastPosition);
        } else {
            m.getSelectedLink().setDestination(null);
            m.getSelectedLink().addBreakPoint((Point)v.lastPosition);
        }
    }
}

