/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.command.ResizeCommand;
import germ.model.Node;
import germ.state.State;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class ResizeState
extends State {
    private Point NW;
    private Point SE;
    ResizeCommand resizeCommand;

    public void mouseDragged(MouseEvent e) {
        GERMView v = Application.getInstance().getView();
        Point mousePosition = (Point)v.lastPosition;
        Node node = v.getNodeChangingShape();
        double nodeWidth = node.getSize().getWidth();
        double nodeHeight = node.getSize().getHeight();
        int moveStep = 10;
        int moveX = 0;
        int moveY = 0;
        double width = v.getWidth();
        double height = v.getHeight();
        double tolerance = 20.0;
        switch (v.getHandleMoving()) {
            case EAST: {
                double width2 = mousePosition.getX() - this.NW.getX();
                node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                break;
            }
            case WEST: {
                double width2 = this.SE.getX() - mousePosition.getX();
                if (!(node.getScaleX() * width2 / nodeWidth >= 0.1) || !(node.getScaleX() * width2 / nodeWidth <= 10.0)) break;
                node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                node.setPosition(new Point2D.Double(mousePosition.getX(), node.getPosition().getY()));
                break;
            }
            case NORTH: {
                double height2 = this.SE.getY() - mousePosition.getY();
                if (!(node.getScaleY() * height2 / nodeHeight >= 0.1) || !(node.getScaleY() * height2 / nodeHeight <= 10.0)) break;
                node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                node.setPosition(new Point2D.Double(node.getPosition().getX(), mousePosition.getY()));
                break;
            }
            case SOUTH: {
                double height2 = mousePosition.getY() - this.NW.getY();
                node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                break;
            }
            case SOUTHEAST: {
                double height2 = mousePosition.getY() - this.NW.getY();
                double width2 = mousePosition.getX() - this.NW.getX();
                node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                if (e.isShiftDown()) {
                    if (e.isControlDown()) {
                        node.setScaleY(node.getScaleY() * width2 / nodeHeight);
                        break;
                    }
                    node.setScaleY(node.getScaleY() * width2 / nodeWidth);
                    break;
                }
                node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                break;
            }
            case SOUTHWEST: {
                double height2 = mousePosition.getY() - this.NW.getY();
                double width2 = this.SE.getX() - mousePosition.getX();
                if (e.isShiftDown()) {
                    if (e.isControlDown()) {
                        node.setScaleY(node.getScaleY() * width2 / nodeHeight);
                    } else {
                        node.setScaleY(node.getScaleY() * width2 / nodeWidth);
                    }
                } else {
                    node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                }
                if (!(node.getScaleX() * width2 / nodeWidth >= 0.1) || !(node.getScaleX() * width2 / nodeWidth <= 10.0)) break;
                node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                node.setPosition(new Point2D.Double(mousePosition.getX(), node.getPosition().getY()));
                break;
            }
            case NORTHEAST: {
                double height2 = this.SE.getY() - mousePosition.getY();
                double width2 = mousePosition.getX() - this.NW.getX();
                if (node.getScaleY() * height2 / nodeHeight >= 0.1 && node.getScaleY() * height2 / nodeHeight <= 10.0) {
                    node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                    node.setPosition(new Point2D.Double(node.getPosition().getX(), mousePosition.getY()));
                }
                if (e.isShiftDown()) {
                    if (e.isControlDown()) {
                        node.setScaleX(node.getScaleX() * height2 / nodeWidth);
                        break;
                    }
                    node.setScaleX(node.getScaleX() * height2 / nodeHeight);
                    break;
                }
                node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                break;
            }
            case NORTHWEST: {
                double height2 = this.SE.getY() - mousePosition.getY();
                double width2 = this.SE.getX() - mousePosition.getX();
                double dif = node.getPosition().getX() - mousePosition.getX();
                if (node.getScaleX() * width2 / nodeWidth >= 0.1 && node.getScaleX() * width2 / nodeWidth <= 10.0) {
                    node.setScaleX(node.getScaleX() * width2 / nodeWidth);
                    node.setPosition(new Point2D.Double(mousePosition.getX(), node.getPosition().getY()));
                }
                if (!(node.getScaleY() * height2 / nodeHeight >= 0.1) || !(node.getScaleY() * height2 / nodeHeight <= 10.0)) break;
                if (e.isShiftDown()) {
                    if (e.isControlDown()) {
                        node.setScaleY(node.getScaleY() * width2 / nodeHeight);
                    } else {
                        node.setScaleY(node.getScaleY() * width2 / nodeWidth);
                    }
                    node.setPosition(new Point2D.Double(node.getPosition().getX(), node.getPosition().getY() - dif));
                    break;
                }
                node.setScaleY(node.getScaleY() * height2 / nodeHeight);
                node.setPosition(new Point2D.Double(node.getPosition().getX(), mousePosition.getY()));
            }
        }
        if ((double)e.getX() >= width - tolerance) {
            moveX -= moveStep;
        }
        if ((double)e.getX() <= tolerance) {
            moveX += moveStep;
        }
        if ((double)e.getY() >= height - tolerance) {
            moveY -= moveStep;
        }
        if ((double)e.getY() <= tolerance) {
            moveY += moveStep;
        }
        v.moveWorkspace(moveX, moveY);
    }

    public void initializeResize(Point position) {
        GERMView v = Application.getInstance().getView();
        Node node = v.getNodeChangingShape();
        this.resizeCommand = new ResizeCommand();
        this.NW = new Point((int)node.getPosition().getX(), (int)node.getPosition().getY());
        this.SE = new Point((int)(node.getPosition().getX() + node.getSize().getWidth()), (int)(node.getPosition().getY() + node.getSize().getHeight()));
    }

    public void mouseReleased(MouseEvent e) {
        this.resizeCommand.resizeEnded();
        Application.getInstance().getCommandManager().doCommand(this.resizeCommand);
        Application.getInstance().getView().setNodeChangingShape(null);
        Application.getInstance().getView().setHandleMoving(null);
        Application.getInstance().getStateMachine().setState(State.defaultState);
    }
}

