/*
 * Decompiled with CFR 0.152.
 */
package germ.state;

import germ.app.Application;
import germ.state.State;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class StateMachine {
    private State currentState = State.defaultState;

    void setState(State s) {
        this.currentState.exit();
        this.currentState = s;
        this.currentState.enter();
        Application.getInstance().getMainWindow().setStatusBarMessage(s.getStateName(), 2);
    }

    public void mousePressed(MouseEvent e) {
        Application.getInstance().getView().requestFocusInWindow();
        this.currentState.mousePressed(e);
    }

    public void mouseClicked(MouseEvent e) {
        this.currentState.mouseClicked(e);
    }

    public void mouseDoubleClicked(MouseEvent e) {
        this.currentState.mouseDoubleClicked(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.currentState.mouseReleased(e);
    }

    public void mouseWheelMoved(MouseEvent e) {
        this.currentState.mouseWheelMoved(e);
    }

    public void mouseMove(MouseEvent e) {
        this.currentState.mouseMove(e);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setState(State.defaultState);
        } else {
            this.currentState.keyPressed(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.currentState.mouseDragged(e);
    }

    public void insertRequirement() {
        this.setState(State.insertRequirementState);
    }

    public void insertArgument() {
        this.setState(State.insertArgumentState);
    }

    public void insertAssumption() {
        this.setState(State.insertAssumptionState);
    }

    public void insertDecision() {
        this.setState(State.insertDecisionState);
    }

    public void insertPosition() {
        this.setState(State.insertPositionState);
    }

    public void insertLink() {
        this.setState(State.insertLinkState);
    }

    public void insertLinkBreakpoint() {
        this.setState(State.insertLinkBreakpointsState);
    }

    public void insertStakeholder() {
        this.setState(State.insertStakeholderState);
    }

    public void insertTopic() {
        this.setState(State.insertTopicState);
    }

    public void zoomClicked() {
        if (this.currentState == State.zoomState) {
            this.setState(State.defaultState);
        } else {
            this.setState(State.zoomState);
        }
    }

    public void lasoZoom() {
        this.setState(State.lasoZoomState);
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void modelChanged() {
        this.currentState.exit();
        this.currentState = State.defaultState;
    }
}

