/*
 * Decompiled with CFR 0.152.
 */
package germ.util;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class Cursors {
    public static Cursor currentCursor;
    private static Hashtable<String, Cursor> cursors;

    static {
        cursors = new Hashtable();
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            File f = new File("germ/actions/cursors/");
            String[] stringArray = f.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cursorImage = stringArray[n2];
                File newCursor = new File("germ/actions/cursors/" + cursorImage);
                if (!newCursor.isDirectory()) {
                    BufferedImage rawCursor = ImageIO.read(newCursor);
                    float scaleFactor = System.getProperty("os.name").indexOf("Linux") != -1 ? 0.4f : 0.7f;
                    BufferedImage result = new BufferedImage(rawCursor.getWidth(), rawCursor.getHeight(), 6);
                    result.createGraphics();
                    Graphics2D g = (Graphics2D)result.getGraphics();
                    g.drawRenderedImage(rawCursor, AffineTransform.getScaleInstance(scaleFactor, scaleFactor));
                    g.dispose();
                    Cursor customCursor = toolkit.createCustomCursor(result, new Point(0, 0), cursorImage);
                    cursors.put(cursorImage.split("\\.")[0], customCursor);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Cursor getCursor(String cursor) {
        if (cursors.containsKey(cursor)) {
            currentCursor = cursors.get(cursor);
            return currentCursor;
        }
        return Cursor.getDefaultCursor();
    }

    public static Cursor getCurrentCursor() {
        return currentCursor;
    }
}

