/*
 * Decompiled with CFR 0.152.
 */
package germ.view;

import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.MainWindow;
import germ.gui.windows.TimerThread;
import germ.model.GERMModel;
import germ.model.Link;
import germ.model.Node;
import germ.model.event.UpdateEvent;
import germ.model.event.UpdateListener;
import germ.state.StateMachine;
import germ.view.Handle;
import germ.view.NodePainter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class GERMView
extends JPanel
implements UpdateListener {
    protected GERMModel model;
    private AffineTransform transform = new AffineTransform();
    public Point2D lastPosition;
    protected Rectangle2D lasoRectangle = new Rectangle2D.Double();
    public boolean lasoEnabled = false;
    private Node nodeChangingShape = null;
    private Handle handleMoving = null;
    private boolean cursorOnCanvas = false;
    private boolean popupMenu = false;

    public void zoom(MouseEvent ee, Object ... args) {
        double zoom;
        float zoomLimit = 10.0f;
        float zoomFactor = 1.2f;
        Point oldPosition = ee.getPoint();
        Point newPosition = ee.getPoint();
        boolean animation = ConfigurationManager.getInstance().getBoolean("animationEnabled");
        TimerThread tt = Application.getInstance().getMainWindow().getTimerThread();
        if (args.length == 0) {
            animation = false;
            MouseWheelEvent e = (MouseWheelEvent)ee;
            zoom = e.getWheelRotation() < 0 ? this.transform.getScaleX() * (double)zoomFactor : this.transform.getScaleX() / (double)zoomFactor;
        } else {
            zoom = (Boolean)args[0] != false ? this.transform.getScaleX() * (double)zoomFactor : this.transform.getScaleX() / (double)zoomFactor;
        }
        try {
            if (zoom > (double)zoomLimit) {
                zoom = zoomLimit;
            } else if (zoom < (double)(1.0f / zoomLimit)) {
                zoom = 1.0f / zoomLimit;
            }
            this.transform.inverseTransform(oldPosition, oldPosition);
            if (!animation) {
                this.transform.setToScale(zoom, zoom);
            }
            this.transform.inverseTransform(newPosition, newPosition);
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        if (animation) {
            tt.setFastZoomAndScale(true);
            tt.setIgnoreMinStepLimit(true);
            tt.setNewScale(zoom);
            tt.setRelocate(new Point2D.Double(((Point2D)newPosition).getX(), ((Point2D)newPosition).getY()));
        } else {
            this.transform.translate(((Point2D)newPosition).getX() - ((Point2D)oldPosition).getX(), ((Point2D)newPosition).getY() - ((Point2D)oldPosition).getY());
            this.repaint();
        }
    }

    public void zoom(double factor) {
        float zoomLimit;
        Point center;
        Point oldPosition = center = new Point(this.getWidth() / 2, this.getHeight() / 2);
        Point2D newPosition = (Point2D)center.clone();
        double zoom = this.transform.getScaleX() + factor;
        if (zoom > (double)(zoomLimit = 10.0f)) {
            zoom = zoomLimit;
        } else if (zoom < (double)(1.0f / zoomLimit)) {
            zoom = 1.0f / zoomLimit;
        }
        try {
            this.transform.inverseTransform(oldPosition, oldPosition);
            this.transform.setToScale(zoom, zoom);
            this.transform.inverseTransform(newPosition, newPosition);
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        this.transform.translate(newPosition.getX() - ((Point2D)oldPosition).getX(), newPosition.getY() - ((Point2D)oldPosition).getY());
        this.repaint();
    }

    public void zoomTo(Rectangle2D rect) {
        float zoomLimit = 10.0f;
        if (rect == null) {
            return;
        }
        Point rectCenter = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
        double scale = (double)this.getWidth() / rect.getWidth();
        if (scale > (double)this.getHeight() / rect.getHeight()) {
            scale = (double)this.getHeight() / rect.getHeight();
        }
        if (scale > (double)zoomLimit) {
            scale = zoomLimit;
        }
        if (ConfigurationManager.getInstance().getBoolean("animationEnabled")) {
            MainWindow mw = Application.getInstance().getMainWindow();
            mw.backupStatusBar();
            mw.setStatusBarMessage("Zooming...", 0);
            mw.getTimerThread().setRelocate(new Point2D.Double(rectCenter.x, rectCenter.y));
            mw.getTimerThread().setNewScale(scale);
        } else {
            this.transform.setToScale(scale, scale);
            Point screenCenter = new Point(this.getWidth() / 2, this.getHeight() / 2);
            try {
                this.transform.inverseTransform(screenCenter, screenCenter);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
            this.transform.translate(screenCenter.getX() - (double)rectCenter.x, screenCenter.getY() - (double)rectCenter.y);
            this.repaint();
        }
    }

    public void moveWorkspace(double x, double y) {
        this.transform.translate(x, y);
        this.repaint();
    }

    public Rectangle2D getLasoRectangle() {
        return this.lasoRectangle;
    }

    public GERMModel getModel() {
        return this.model;
    }

    public GERMView(GERMModel _model) {
        this.setFocusable(true);
        this.model = _model;
        this.model.addUpdateListener(this);
        GERMController controller = new GERMController();
        this.addMouseListener(controller);
        this.addMouseMotionListener(controller);
        this.addMouseWheelListener(controller);
        this.addKeyListener(new KeyController());
        this.setBackground(ConfigurationManager.getInstance().getColor("background"));
    }

    protected void paintComponent(Graphics g) {
        Node d;
        Iterator<Node> it;
        this.setBackground(ConfigurationManager.getInstance().getColor("background"));
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.transform(this.transform);
        if (ConfigurationManager.getInstance().getBoolean("showGrid")) {
            this.drawGrid(g2);
        }
        this.drawLaso(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
        if (ConfigurationManager.getInstance().getBoolean("nodeShadow")) {
            it = this.model.getNodeIterator();
            while (it.hasNext()) {
                d = it.next();
                ((NodePainter)d.getPainter()).drawShadow(g2);
            }
        }
        it = this.model.getGhostNodesIterator();
        while (it.hasNext()) {
            d = it.next();
            d.getPainter().paint(g2);
        }
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Iterator<Link> lit = this.model.getLinkIterator();
        while (lit.hasNext()) {
            Link l = lit.next();
            l.getPainter().paint(g2);
        }
        it = this.model.getNodeIterator();
        while (it.hasNext()) {
            Node d2 = it.next();
            d2.getPainter().paint(g2);
        }
        it = this.model.getSelectedNodesIterator();
        while (it.hasNext()) {
            Node n = it.next();
            this.drawNodeSelectionRectangles(g2, n);
        }
        Link selectedLink = this.model.getSelectedLink();
        if (selectedLink != null) {
            this.drawLinkBreakPoints(g2);
        }
        this.drawLaso(g2);
        this.drawMouseOverNodeIndicator(g2);
    }

    private void drawNodeSelectionRectangles(Graphics2D g2, Node n) {
        g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
        g2.setStroke(new BasicStroke());
        double gap = 4.0 / this.transform.getScaleX();
        g2.setPaint(this.getThemeColor());
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(n.getPosition().getX() - gap, n.getPosition().getY() - gap, n.getSize().getWidth() + gap * 2.0, n.getSize().getHeight() + gap * 2.0, 15.0, 15.0);
        g2.fill(rr);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2.draw(rr);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        Handle[] handleArray = Handle.values();
        int n2 = handleArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Handle h = handleArray[n3];
            g2.fill(this.getHandleRect(h, n));
            ++n3;
        }
    }

    private void drawMouseOverNodeIndicator(Graphics2D g2) {
        Node n = this.model.getMouseOverNode();
        if (n != null) {
            g2.setStroke(new BasicStroke());
            g2.setPaint(this.getThemeColor());
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            RoundRectangle2D r = this.getNodeRoundRectangle(n);
            g2.fill(r);
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.draw(r);
        }
    }

    private RoundRectangle2D getNodeRoundRectangle(Node n) {
        double gap = 6.0;
        RoundRectangle2D.Double r = new RoundRectangle2D.Double(n.getPosition().getX() - gap, n.getPosition().getY() - gap, n.getSize().getWidth() + 2.0 * gap, n.getSize().getHeight() + 2.0 * gap, 15.0, 15.0);
        return r;
    }

    private Shape getHandleRect(Handle handle, Node n) {
        double gap = 4.0;
        double size = 10.0 / this.transform.getScaleX();
        double round = 10.0;
        switch (handle) {
            case EAST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() + n.getSize().getWidth(), n.getPosition().getY() + n.getSize().getHeight() / 2.0 - gap, size, size, round, round);
            }
            case WEST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() - gap - size / 2.0, n.getPosition().getY() + n.getSize().getHeight() / 2.0 - gap, size, size, round, round);
            }
            case NORTH: {
                return new RoundRectangle2D.Double(n.getPosition().getX() + n.getSize().getWidth() / 2.0 - size / 2.0, n.getPosition().getY() - gap - size / 2.0, size, size, round, round);
            }
            case SOUTH: {
                return new RoundRectangle2D.Double(n.getPosition().getX() + n.getSize().getWidth() / 2.0 - size / 2.0, n.getPosition().getY() + n.getSize().getHeight() - gap / 2.0, size, size, round, round);
            }
            case SOUTHEAST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() + n.getSize().getWidth(), n.getPosition().getY() + n.getSize().getHeight() - gap / 2.0, size, size, round, round);
            }
            case SOUTHWEST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() - gap - size / 2.0, n.getPosition().getY() + n.getSize().getHeight() - gap / 2.0, size, size, round, round);
            }
            case NORTHEAST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() + n.getSize().getWidth(), n.getPosition().getY() - gap - size / 2.0, size, size, round, round);
            }
            case NORTHWEST: {
                return new RoundRectangle2D.Double(n.getPosition().getX() - gap - size / 2.0, n.getPosition().getY() - gap - size / 2.0, size, size, round, round);
            }
        }
        return null;
    }

    private void drawLinkBreakPoints(Graphics2D g2) {
        Point point2;
        Link link = this.model.getSelectedLink();
        ArrayList<Point> breakpoints = link.getBreakPoints();
        float size = 7.0f;
        double round = 2.0;
        g2.setColor(Color.BLACK);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (Point point2 : breakpoints) {
            g2.fill(new RoundRectangle2D.Double(point2.getX() - (double)(size / 2.0f), point2.getY() - (double)(size / 2.0f), size, size, round, round));
        }
        if (link.getSource() != null) {
            point2 = link.getSourceCenterPosition();
            g2.fill(new RoundRectangle2D.Double(point2.getX() - (double)(size / 2.0f), point2.getY() - (double)(size / 2.0f), size, size, round, round));
        }
        if (link.getDestination() != null) {
            point2 = link.getDestinationCenterPosition();
            g2.fill(new RoundRectangle2D.Double(point2.getX() - (double)(size / 2.0f), point2.getY() - (double)(size / 2.0f), size, size, round, round));
        }
    }

    private void drawLaso(Graphics2D g2) {
        if (this.lasoEnabled) {
            g2.setPaint(this.getThemeColor());
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            double sX = this.model.getLasoBegin().getX();
            double sY = this.model.getLasoBegin().getY();
            double eX = this.model.getLasoEnd().getX();
            double eY = this.model.getLasoEnd().getY();
            if (sX > eX && sY > eY) {
                this.lasoRectangle.setRect(eX, eY, Math.abs(this.model.getLasoEnd().getX() - this.model.getLasoBegin().getX()), Math.abs(this.model.getLasoEnd().getY() - this.model.getLasoBegin().getY()));
            } else if (sX > eX && sY < eY) {
                this.lasoRectangle.setRect(eX, sY, Math.abs(this.model.getLasoEnd().getX() - this.model.getLasoBegin().getX()), Math.abs(this.model.getLasoEnd().getY() - this.model.getLasoBegin().getY()));
            } else if (sX < eX && sY > eY) {
                this.lasoRectangle.setRect(sX, eY, Math.abs(this.model.getLasoEnd().getX() - this.model.getLasoBegin().getX()), Math.abs(this.model.getLasoEnd().getY() - this.model.getLasoBegin().getY()));
            } else {
                this.lasoRectangle.setRect(sX, sY, Math.abs(this.model.getLasoEnd().getX() - this.model.getLasoBegin().getX()), Math.abs(this.model.getLasoEnd().getY() - this.model.getLasoBegin().getY()));
            }
            g2.fill(this.lasoRectangle);
            g2.setStroke(new BasicStroke(0.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.draw(this.lasoRectangle);
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            if (ConfigurationManager.getInstance().getBoolean("lasoOverNodeShow")) {
                g2.setStroke(new BasicStroke(0.0f));
                g2.setPaint(this.getThemeColor());
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
                for (Node n : this.model.getNodes()) {
                    if (!this.lasoRectangle.intersects(new Rectangle2D.Double(n.getPosition().getX(), n.getPosition().getY(), n.getSize().width, n.getSize().height))) continue;
                    g2.fill(this.getNodeRoundRectangle(n));
                }
            }
        }
    }

    public void setMouseCursor(Point2D point) {
        Handle handle = this.getHandleForPoint(point);
        if (handle != null) {
            Cursor cursor = null;
            switch (handle) {
                case NORTH: {
                    cursor = Cursor.getPredefinedCursor(8);
                    break;
                }
                case SOUTH: {
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case EAST: {
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case WEST: {
                    cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case SOUTHEAST: {
                    cursor = Cursor.getPredefinedCursor(5);
                    break;
                }
                case NORTHWEST: {
                    cursor = Cursor.getPredefinedCursor(6);
                    break;
                }
                case SOUTHWEST: {
                    cursor = Cursor.getPredefinedCursor(4);
                    break;
                }
                case NORTHEAST: {
                    cursor = Cursor.getPredefinedCursor(7);
                }
            }
            this.setCursor(cursor);
        }
    }

    public Handle getHandleForPoint(Point2D point) {
        if (this.getModel().getSelectedNodes().size() > 0) {
            Iterator<Node> iter = this.getModel().getSelectedNodesIterator();
            while (iter.hasNext()) {
                this.nodeChangingShape = iter.next();
                Handle handle = this.getHandleForPoint(this.nodeChangingShape, point);
                if (handle == null) continue;
                return handle;
            }
        }
        this.nodeChangingShape = null;
        return null;
    }

    private Handle getHandleForPoint(Node node, Point2D point) {
        Handle[] handleArray = Handle.values();
        int n = handleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handle h = handleArray[n2];
            if (this.isPointInHandle(node, point, h)) {
                return h;
            }
            ++n2;
        }
        return null;
    }

    private boolean isPointInHandle(Node node, Point2D point, Handle handle) {
        return this.getHandleRect(handle, node).contains(point);
    }

    public void centerNode(Node node) {
        if (ConfigurationManager.getInstance().getBoolean("animationEnabled")) {
            Application.getInstance().getMainWindow().getTimerThread().setRelocate(new Point2D.Double(node.getSize().getWidth() / 2.0 + node.getPosition().getX(), node.getSize().getHeight() / 2.0 + node.getPosition().getY()));
        } else {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            ((Rectangle2D)rect).setRect(node.getPosition().getX() - (double)(this.getWidth() / 2) + node.getSize().getWidth() / 2.0, node.getPosition().getY() - (double)(this.getHeight() / 2) + node.getSize().getHeight() / 2.0, this.getWidth(), this.getHeight());
            this.zoomTo(rect);
        }
    }

    private void drawGrid(Graphics2D g2) {
        GeneralPath lines = new GeneralPath();
        GeneralPath detailLines = new GeneralPath();
        g2.setStroke(new BasicStroke(0.0f));
        g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2.setPaint(ConfigurationManager.getInstance().getColor("gridColor"));
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(this.getWidth(), this.getHeight());
        try {
            this.transform.inverseTransform(startPoint, startPoint);
            this.transform.inverseTransform(endPoint, endPoint);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        if (this.transform.getScaleX() > 3.0) {
            int start = (int)((Point2D)startPoint).getX();
            while (start < (int)((Point2D)endPoint).getX()) {
                if (start % 25 == 0) {
                    detailLines.moveTo((double)start, ((Point2D)startPoint).getY());
                    detailLines.lineTo((double)start, ((Point2D)startPoint).getY() + (double)this.getHeight() / this.transform.getScaleY());
                }
                ++start;
            }
            start = (int)((Point2D)startPoint).getY();
            while (start < (int)((Point2D)endPoint).getY()) {
                if (start % 25 == 0) {
                    detailLines.moveTo(((Point2D)startPoint).getX(), (double)start);
                    detailLines.lineTo(((Point2D)startPoint).getX() + (double)this.getWidth() / this.transform.getScaleX(), (double)start);
                }
                ++start;
            }
            g2.draw(detailLines);
        }
        int distance = 100;
        if (this.transform.getScaleX() < 0.25) {
            distance = 300;
        }
        if (this.transform.getScaleX() <= (double)0.1f) {
            distance = 600;
        }
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setPaint(ConfigurationManager.getInstance().getColor("gridColor"));
        int start = (int)((Point2D)startPoint).getX();
        while (start < (int)((Point2D)endPoint).getX()) {
            if (start % distance == 0) {
                lines.moveTo((double)start, ((Point2D)startPoint).getY());
                lines.lineTo((double)start, ((Point2D)startPoint).getY() + (double)this.getHeight() / this.transform.getScaleY());
            }
            ++start;
        }
        start = (int)((Point2D)startPoint).getY();
        while (start < (int)((Point2D)endPoint).getY()) {
            if (start % distance == 0) {
                lines.moveTo(((Point2D)startPoint).getX(), (double)start);
                lines.lineTo(((Point2D)startPoint).getX() + (double)this.getWidth() / this.transform.getScaleX(), (double)start);
            }
            ++start;
        }
        g2.draw(lines);
    }

    private Paint getThemeColor() {
        String theme = ConfigurationManager.getInstance().getConfigParameter("theme");
        Color p = new Color(0, 0, 0);
        if (theme.equals("orange/")) {
            p = new Color(254, 116, 24);
        }
        if (theme.equals("blue/")) {
            p = new Color(0, 106, 197);
        }
        if (theme.equals("green/")) {
            p = new Color(30, 200, 30);
        }
        return p;
    }

    public Node getNodeChangingShape() {
        return this.nodeChangingShape;
    }

    public void setNodeChangingShape(Node nodeChangingShape) {
        this.nodeChangingShape = nodeChangingShape;
    }

    public Handle getHandleMoving() {
        return this.handleMoving;
    }

    public void setHandleMoving(Handle handleMoving) {
        this.handleMoving = handleMoving;
    }

    public Point getCanvasCenter() {
        Point screenCenter = new Point(this.getWidth() / 2, this.getHeight() / 2);
        try {
            return (Point)this.transform.inverseTransform(screenCenter, screenCenter);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void zoomToLasoRectangle() {
        this.zoomTo(this.lasoRectangle);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public void setModel(GERMModel model) {
        this.model = model;
        this.repaint();
    }

    public boolean isCursorOnCanvas() {
        if (this.popupMenu) {
            return true;
        }
        return this.cursorOnCanvas;
    }

    public String toString() {
        return this.getModel().toString();
    }

    public void updatePerformed(UpdateEvent e) {
        this.repaint();
    }

    private class GERMController
    extends MouseAdapter {
        private GERMController() {
        }

        public void mousePressed(MouseEvent e) {
            GERMView.this.lastPosition = e.getPoint();
            if (e.getButton() == 3) {
                GERMView.this.popupMenu = true;
            }
            try {
                GERMView.this.transform.inverseTransform(GERMView.this.lastPosition, GERMView.this.lastPosition);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
            GERMView.this.handleMoving = GERMView.this.getHandleForPoint(GERMView.this.lastPosition);
            Application.getInstance().getStateMachine().mousePressed(e);
        }

        public void mouseClicked(MouseEvent e) {
            StateMachine sm = Application.getInstance().getStateMachine();
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                sm.mouseDoubleClicked(e);
            }
            sm.mouseClicked(e);
        }

        public void mouseReleased(MouseEvent e) {
            GERMView.this.lastPosition = e.getPoint();
            try {
                GERMView.this.transform.inverseTransform(GERMView.this.lastPosition, GERMView.this.lastPosition);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
            GERMView.this.handleMoving = null;
            Application.getInstance().getStateMachine().mouseReleased(e);
        }

        public void mouseDragged(MouseEvent e) {
            GERMView.this.lastPosition = e.getPoint();
            try {
                GERMView.this.transform.inverseTransform(GERMView.this.lastPosition, GERMView.this.lastPosition);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
            Application.getInstance().getStateMachine().mouseDragged(e);
            Application.getInstance().getMainWindow().setStatusBarMessage("<" + GERMView.this.lastPosition.getX() + "," + GERMView.this.lastPosition.getY() + ">", 1);
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isShiftDown()) {
                GERMView.this.transform.translate((double)((float)e.getWheelRotation() * 25.0f) / GERMView.this.transform.getScaleY(), 0.0);
            } else if (!e.isControlDown() && !e.isShiftDown()) {
                GERMView.this.transform.translate(0.0, (double)((float)(-e.getWheelRotation()) * 25.0f) / GERMView.this.transform.getScaleX());
            } else if (e.isControlDown()) {
                GERMView.this.zoom(e, new Object[0]);
            }
            GERMView.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            GERMView.this.lastPosition = e.getPoint();
            try {
                GERMView.this.transform.inverseTransform(GERMView.this.lastPosition, GERMView.this.lastPosition);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
            Application.getInstance().getStateMachine().mouseMove(e);
            Application.getInstance().getMainWindow().setStatusBarMessage("<" + GERMView.this.lastPosition.getX() + "," + GERMView.this.lastPosition.getY() + ">", 1);
        }

        public void mouseEntered(MouseEvent e) {
            GERMView.this.popupMenu = false;
            GERMView.this.cursorOnCanvas = true;
            GERMView.this.requestFocus();
        }

        public void mouseExited(MouseEvent e) {
            GERMView.this.cursorOnCanvas = false;
        }
    }

    private class KeyController
    extends KeyAdapter {
        private KeyController() {
        }

        public void keyPressed(KeyEvent e) {
            Application.getInstance().getStateMachine().keyPressed(e);
        }
    }
}

