/*
 * Decompiled with CFR 0.152.
 */
package germ.view;

import germ.configuration.InternalConfiguration;
import germ.model.GraphElement;
import germ.model.Link;
import germ.view.GraphElementPainter;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class LinkPainter
extends GraphElementPainter {
    protected Shape shape;
    protected Link link;

    public LinkPainter(GraphElement element) {
        super(element);
        this.link = (Link)element;
    }

    private void reshape() {
        Link l = (Link)this.element;
        boolean sourceNotDefined = true;
        GeneralPath line = new GeneralPath();
        if (l.getSource() != null) {
            sourceNotDefined = false;
            line.moveTo(l.getSource().getPosition().getX() + (double)(l.getSource().getSize().width / 2), l.getSource().getPosition().getY() + (double)(l.getSource().getSize().height / 2));
        }
        Iterator<Point> it = l.getBreakPointIterator();
        while (it.hasNext()) {
            Point p = it.next();
            if (sourceNotDefined) {
                line.moveTo(p.getX(), p.getY());
            } else {
                line.lineTo(p.getX(), p.getY());
            }
            sourceNotDefined = false;
        }
        if (l.getDestination() != null) {
            line.lineTo(l.getDestination().getPosition().getX() + (double)(l.getDestination().getSize().width / 2), l.getDestination().getPosition().getY() + (double)(l.getDestination().getSize().height / 2));
        }
        this.shape = line;
    }

    public boolean isElementAt(Point2D pos) {
        double newY;
        double newX;
        float tol = InternalConfiguration.LINK_HIT_TOLERANCE;
        if (this.link.getBreakPointCount() < 1) {
            return this.shape.intersects(pos.getX() - (double)tol, pos.getY() - (double)tol, 2.0f * tol, 2.0f * tol);
        }
        Line2D.Double line = new Line2D.Double();
        boolean noSource = true;
        if (this.link.getSource() != null) {
            noSource = false;
            newX = this.link.getSource().getSize().getWidth() / 2.0 + this.link.getSource().getPosition().getX();
            newY = this.link.getSource().getSize().getHeight() / 2.0 + this.link.getSource().getPosition().getY();
            ((Line2D)line).setLine(newX, newY, 0.0, 0.0);
        }
        for (Point bp : this.link.getBreakPoints()) {
            if (noSource) {
                ((Line2D)line).setLine(bp.getX(), bp.getY(), 0.0, 0.0);
                noSource = false;
                continue;
            }
            ((Line2D)line).setLine(((Line2D)line).getX1(), ((Line2D)line).getY1(), bp.getX(), bp.getY());
            if (line.intersects(pos.getX() - (double)tol, pos.getY() - (double)tol, 2.0f * tol, 2.0f * tol)) {
                return true;
            }
            ((Line2D)line).setLine(bp.getX(), bp.getY(), 0.0, 0.0);
        }
        if (this.link.getDestination() != null) {
            newX = this.link.getDestination().getSize().getWidth() / 2.0 + this.link.getDestination().getPosition().getX();
            newY = this.link.getDestination().getSize().getHeight() / 2.0 + this.link.getDestination().getPosition().getY();
            ((Line2D)line).setLine(((Line2D)line).getX1(), ((Line2D)line).getY1(), newX, newY);
            if (line.intersects(pos.getX() - (double)tol, pos.getY() - (double)tol, 2.0f * tol, 2.0f * tol)) {
                return true;
            }
        }
        return false;
    }

    public Point getBreakpointAt(Point2D pos) {
        if (pos == null) {
            return null;
        }
        float tol = InternalConfiguration.LINK_HIT_TOLERANCE;
        Rectangle2D.Double rect = new Rectangle2D.Double();
        for (Point current : this.link.getBreakPoints()) {
            rect.setFrame(current.getX() - (double)tol, current.getY() - (double)tol, 2.0f * tol, 2.0f * tol);
            if (!rect.contains(pos)) continue;
            return current;
        }
        return null;
    }

    public void paint(Graphics2D g) {
        Link node = (Link)this.element;
        this.reshape();
        g.setPaint(node.getStrokePaint());
        g.setStroke(node.getStroke());
        g.draw(this.getShape());
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }
}

