/*
 * Decompiled with CFR 0.152.
 */
package germ.view;

import germ.configuration.InternalConfiguration;
import germ.model.Node;
import germ.view.GraphElementPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class NodePainter
extends GraphElementPainter {
    protected Shape shape;

    public NodePainter(Node device) {
        super(device);
    }

    public void paint(Graphics2D g) {
        Node node = (Node)this.element;
        double translateX = node.getPosition().getX();
        if (node.getFlip() < 0) {
            translateX += node.getSize().getWidth();
        }
        g.translate(translateX, node.getPosition().getY());
        g.scale(node.getScaleX() * (double)node.getFlip(), node.getScaleY());
        g.setPaint(node.getPaint());
        g.fill(this.getShape());
        g.setPaint(node.getStrokePaint());
        g.setStroke(node.getStroke());
        g.draw(this.getShape());
        g.setPaint(Color.BLACK);
        g.scale(1.0 / node.getScaleX() / (double)node.getFlip(), 1.0 / node.getScaleY());
        if (node.getFlip() < 0) {
            g.translate(-node.getSize().getWidth(), 0.0);
        }
        g.setFont(new Font("Serif", 0, 14));
        Rectangle2D text = g.getFontMetrics().getStringBounds(node.getName(), g);
        g.drawString(node.getName(), (float)Math.round((double)(node.getSize().width / 2) - text.getWidth() / 2.0), (float)Math.round((double)node.getSize().height + text.getHeight() * 5.0 / 4.0));
        g.translate(-node.getPosition().getX(), -node.getPosition().getY());
    }

    public boolean isElementAt(Point2D pos) {
        Node node = (Node)this.element;
        return this.getShape().contains((pos.getX() - node.getPosition().getX()) / node.getScaleX(), (pos.getY() - node.getPosition().getY()) / node.getScaleY());
    }

    public boolean isCenterHit(Point2D pos) {
        Node node = (Node)this.element;
        float tol = InternalConfiguration.LINK_HIT_TOLERANCE;
        double newX = node.getSize().getWidth() / 2.0 + node.getPosition().getX() - (double)tol;
        double newY = node.getSize().getHeight() / 2.0 + node.getPosition().getY() - (double)tol;
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrame(newX, newY, 2.0f * tol, 2.0f * tol);
        return rect.contains(pos);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void drawShadow(Graphics2D g) {
        Node node = (Node)this.element;
        double translateX = node.getPosition().getX();
        if (node.getFlip() < 0) {
            translateX += node.getSize().getWidth();
        }
        g.translate(translateX + 7.0, node.getPosition().getY() + 7.0);
        g.scale(node.getScaleX() * (double)node.getFlip(), node.getScaleY());
        g.setPaint(Color.BLACK);
        g.fill(this.getShape());
        g.scale(1.0 / node.getScaleX() / (double)node.getFlip(), 1.0 / node.getScaleY());
        g.translate(-translateX - 7.0, -node.getPosition().getY() - 7.0);
    }
}

