/*
 * Decompiled with CFR 0.152.
 */
package germ.view.painters;

import germ.model.Node;
import germ.model.nodes.Argument;
import germ.model.nodes.ArgumentValue;
import germ.view.NodePainter;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ArgumentPainter
extends NodePainter {
    Shape hexagone;

    public ArgumentPainter(Node node) {
        super(node);
        Argument req = (Argument)node;
        this.reshape(req);
    }

    public void reshape(Argument req) {
        GeneralPath outline = new GeneralPath();
        float width = (float)((double)req.getSize().width / req.getScaleX());
        float height = (float)((double)req.getSize().height / req.getScaleY());
        outline.moveTo(width / 4.0f, 0.0f);
        outline.lineTo(0.0f, height / 2.0f);
        outline.lineTo(width / 4.0f, height);
        outline.lineTo(width * 3.0f / 4.0f, height);
        outline.lineTo(width, height / 2.0f);
        outline.lineTo(width * 3.0f / 4.0f, 0.0f);
        outline.lineTo(width / 4.0f, 0.0f);
        outline.lineTo(width / 4.0f, 0.0f);
        outline.closePath();
        this.hexagone = (Shape)outline.clone();
        Shape outline1 = req.getValue() == ArgumentValue.ARG_NEGATIVE ? this.drawNegative(req) : (req.getValue() == ArgumentValue.ARG_AFFIRMATIVE ? this.drawAffirmative(req) : this.drawNeutral(req));
        outline.setWindingRule(0);
        outline.append(outline1, false);
        this.shape = outline;
    }

    private Shape drawNeutral(Argument req) {
        GeneralPath outline = new GeneralPath();
        float width = (float)((double)req.getSize().width / req.getScaleX());
        float height = (float)((double)req.getSize().height / req.getScaleY());
        outline.moveTo(width * 3.0f / 8.0f, height * 3.0f / 8.0f);
        outline.curveTo(width * 3.0f / 8.0f, height * 7.0f / 16.0f, width * 5.0f / 8.0f, height * 7.0f / 16.0f, width * 5.0f / 8.0f, height * 3.0f / 8.0f);
        outline.curveTo(width * 9.0f / 16.0f, height * 4.0f / 8.0f, width * 9.0f / 16.0f, height * 6.0f / 8.0f, width * 5.0f / 8.0f, height * 7.0f / 8.0f);
        outline.curveTo(width * 5.0f / 8.0f, height * 13.0f / 16.0f, width * 3.0f / 8.0f, height * 13.0f / 16.0f, width * 3.0f / 8.0f, height * 7.0f / 8.0f);
        outline.curveTo(width * 7.0f / 16.0f, height * 6.0f / 8.0f, width * 7.0f / 16.0f, height * 4.0f / 8.0f, width * 3.0f / 8.0f, height * 3.0f / 8.0f);
        outline.closePath();
        outline.append(new Ellipse2D.Double(width * 3.0f / 8.0f, height / 8.0f, width / 4.0f, height / 4.0f), false);
        return outline;
    }

    private Shape drawAffirmative(Argument req) {
        GeneralPath outline = new GeneralPath();
        float width = (float)((double)req.getSize().width / req.getScaleX());
        float height = (float)((double)req.getSize().height / req.getScaleY());
        outline.moveTo(width * 6.0f / 8.0f, height / 8.0f);
        outline.lineTo(width * 3.0f / 8.0f, height * 6.0f / 8.0f);
        outline.lineTo(width / 8.0f, height / 2.0f);
        outline.lineTo(width * 3.0f / 8.0f, height * 7.0f / 8.0f);
        outline.closePath();
        return outline;
    }

    private Shape drawNegative(Argument req) {
        float width = (float)((double)req.getSize().width / req.getScaleX());
        float height = (float)((double)req.getSize().height / req.getScaleY());
        GeneralPath outline = new GeneralPath();
        outline.moveTo(width / 4.0f, height / 16.0f);
        outline.lineTo(width * 3.0f / 16.0f, height / 4.0f);
        outline.lineTo(width * 7.0f / 16.0f, height / 2.0f);
        outline.lineTo(width * 3.0f / 16.0f, height * 3.0f / 4.0f);
        outline.lineTo(width / 4.0f, height * 15.0f / 16.0f);
        outline.lineTo(width / 2.0f, height * 9.0f / 16.0f);
        outline.lineTo(width * 3.0f / 4.0f, height * 15.0f / 16.0f);
        outline.lineTo(width * 13.0f / 16.0f, height * 3.0f / 4.0f);
        outline.lineTo(width * 9.0f / 16.0f, height / 2.0f);
        outline.lineTo(width * 13.0f / 16.0f, height / 4.0f);
        outline.lineTo(width * 3.0f / 4.0f, height / 16.0f);
        outline.lineTo(width / 2.0f, height * 7.0f / 16.0f);
        outline.closePath();
        return outline;
    }

    public boolean isElementAt(Point2D pos) {
        Node node = (Node)this.element;
        return this.hexagone.contains((pos.getX() - node.getPosition().getX()) / node.getScaleX(), (pos.getY() - node.getPosition().getY()) / node.getScaleY());
    }
}

